<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    @include('components.head')
    <body>
        @component('components.nav')
            @slot('title')
                Clientes externos
            @endslot
        @endcomponent
        <form action="/admin/external-business-clients" method="POST" class="container">
            @include('components.messages')
            {{ csrf_field() }}

            @if (!empty($business->id))
                <input type="hidden" name="id" value="{{$business->id}}">
            @endif
            <div class="card">
                <div class="card-header">
                    <table width="100%">
                        <tr>
                            <td>
                                <h5 class="card-title">Cliente externo</h5>
                            </td>
                            <td>
                                @if ($business->id)
                                <div class="d-flex justify-content-end">
                                    <a href="/admin/employees/{{ $business->id }}/external-business-export" target="_blank" class="btn btn-sm btn-secondary" title="Descargar empleados"><i class="fa fa-file-excel mr-2"></i>Descargar empleados</a>
                                </div>
                                @endif
                            </td>
                        </tr>
                    </table>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="name">Nombre</label>
                                <input class="form-control" id="name" name="name" value="{{ old('name', $business->name)}}" placeholder="Nombre del cliente" required>
                                {!!$errors->first('name', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="rfc">RFC</label>
                                <input class="form-control" id="rfc" name="rfc" value="{{ old('rfc', $business->rfc)}}" 
                                    placeholder="Rfc del cliente" maxlength="13" style="text-transform:uppercase" required>
                                {!!$errors->first('rfc', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                            </div>
                        </div>

                        <div class="col-sm-12 col-md-4">
                            <div class="input-group mb-4">
                                <div class="form-group">
                                    <label for="retention">% de retención de IVA</label>
                                    <input type="number" class="form-control" id="retention" name="retention" value="{{ old('retention', $business->retention), 2 }}" step="0.01">
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="row">                        
                        <div class="col-sm-12 col-md-12">
                            <div class="form-group">
                                <label for="address">Dirección</label>
                                <textarea class="form-control" id="address" name="address" maxlength="500">{{ old('address', $business->address)}}</textarea>
                                {!!$errors->first('address', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                            </div>
                        </div>
                    </div>
                    <div class="row">                        
                        <div class="col-sm-12 col-md-12">
                            <div class="form-group">
                                <label for="pay-period">Consorcio</label>
                                <select name="partnership" class="custom-select" id="partnership">
                                    <option value="" selected>Seleccione un consorcio</option>
                                    @foreach ($partnerships as $partnership)
                                        <option value="{{ $partnership->id }}" {{ $partnership->id === old('partnership', $business->partnership_id) ? 'selected' : '' }}>{{ $partnership->code }} - {{ $partnership->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="card-footer d-flex justify-content-between">
                    <a href="/admin/external-business-clients" class="btn btn-sm btn-outline-secondary mr-2"><i class="fa fa-chevron-left mr-2"></i>Regresar</a>
                    <button formmethod="POST" formaction="/admin/external-business-clients/store" name="action" value="{{ Session::token() }}" type="submit" class="btn btn-sm btn-success ml-2"><i class="fa fa-check mr-2"></i>Confirmar</button>
                </div>
            </div>
        </form>
        @include('components.footer')
    </body>
</html>
