<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    @include('components.head')
    <body>
        @component('components.nav')
            @slot('title')
                Empleados
            @endslot
        @endcomponent
        <form action="/admin/employees" method="POST" class="container">
            @include('components.messages')
            {{ csrf_field() }}

            <div class="card">
                <div class="card-header">
                    <h5>Empleado</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-sm-12 col-md-3">
                            <div class="form-group">
                                <input type="hidden" id="id" name="id" value="{{ $employee->id }}">
                                <label for="employee-num">Número de empleado</label>
                                <input class="form-control" id="employee-num" name="employee-num" value="{{ $employee->employee_number }}" disabled>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-3">
                            <div class="form-group">
                                <label for="name">Nombre</label>
                                <input class="form-control" id="name" name="name" value="{{ $employee->name }}" required>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-3">
                            <div class="form-group">
                                <label for="last-name">A. Paterno</label>
                                <input class="form-control" id="last-name" name="last-name" value="{{ $employee->last_name }}" required>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-3">
                            <div class="form-group">
                                <label for="last-name2">A. Materno</label>
                                <input class="form-control" id="last-name2" name="last-name2" value="{{ $employee->last_name2 }}">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12 col-md-3">
                            <div class="form-group">
                                <label for="rfc">RFC</label>
                                <input class="form-control" id="rfc" name="rfc" maxlength="13" value="{{ $employee->rfc }}" style="text-transform:uppercase" required>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-3">
                            <div class="form-group">
                                <label for="curp">Curp</label>
                                <input class="form-control" id="curp" name="curp" maxlength="18" value="{{ $employee->curp }}" style="text-transform:uppercase" required>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-3">
                            <div class="form-group">
                                <label for="type">Tipo</label>
                                <select name="type" class="custom-select" id="type">
                                    <option value="W" {{ old('type', $employee->type) == 'W' ? "selected":"" }}>Trabajador</option>
                                    <option value="C" {{ old('type', $employee->type) == 'C' ? "selected":"" }}>Colaborador</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-3">
                            <div class="form-group">
                                <label for="partnership">Consorcio</label>
                                <select name="partnership" class="custom-select" id="partnership">
                                    @foreach ($partnerships as $partnership)
                                        <option value="{{ $partnership->id }}" {{ $employee->partnership_id == $partnership->id ? "selected":"" }}>{{ $partnership->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                    @if (isset($employee->partnership->businessClients) && count($employee->partnership->businessClients) > 0)
                        <div class="row">
                            <div class="col-sm-12 col-md-12 mt-2">
                                <ul id="business" class="list-group">
                                    <li class="list-group-item list-group-item-info">Empresas</li>
                                    @foreach ($employee->partnership->businessClients as $i)
                                    <li class="list-group-item d-flex justify-content-between">
                                        <div class="d-flex">
                                            <div class="custom-control custom-checkbox mr-2">
                                                <input data-domain-translation="{{$i->domain_translation ? 'on' : 'off'}}" type="checkbox" class="custom-control-input" name="business[]" value="{{$i->id}}" id="business-{{$i->id}}" {{ $employee->isActive($i->id) ? 'checked' : '' }}>
                                                <label class="custom-control-label" for="business-{{$i->id}}"></label>
                                            </div>
                                            <span>{{ $i->name }}</span>
                                        </div>
                                    </li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                    @endif
                </div>
                <div class="card-footer d-flex justify-content-between">
                    <a href="/admin/employees?client={{ $employee->business_client_id }}" class="btn btn-sm btn-outline-secondary mr-2"><i class="fa fa-chevron-left mr-2"></i>Regresar</a>
                    <button name="action" value="store" type="submit" class="btn btn-sm btn-success ml-2"><i class="fa fa-check mr-2"></i>Confirmar</button>
                </div>
            </div>
        </form>
        @include('components.footer')
    </body>
</html>
