<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    @include('components.head')
    <body>
        @component('components.nav')
            @slot('title')
                Empleados
            @endslot
        @endcomponent
        <form action="/admin/employees" method="POST" class="container-fluid">
            {{ csrf_field() }}
            @include('components.messages')
            <table class="table border">
                <thead class="thead-light">
                    <tr>
                        <th scope="col" colspan="4">
                            <span>
                                <button type="submit" data-toggle="modal" class="btn btn-sm btn-primary back" name="action" 
                                    value="create">
                                    <i class="fa fa-plus mr-2"></i>Agregar empleado
                                </button>
                                <button type="submit" data-toggle="modal" class="btn btn-sm btn-success back mr-5" name="action" value="export">
                                    <i class="fa fa-file-excel mr-2"></i>Descargar
                                </button>
                                <button type="submit" data-toggle="modal" class="btn btn-sm btn-danger back" name="action" value="destroy">
                                    <i class="fa fa-trash mr-2"></i>Dar de baja empleado
                                </button>
                            </span>
                        </th>
                        <th scope="col" colspan="2" class="text-right">
                            Número de empleados: <strong>{{ $total }}</strong>
                        </th>
                    </tr>
                    <tr>
                        <th scope="col" colspan="6">
                            <span class="d-flex">
                                <div class="form-group mr-4">
                                    <label for="partnership"><small class="form-text text-muted">Consorcio</small></label>
                                    <select name="partnership" class="custom-select" id="partnership">
                                        <option value="T" selected>Todos</option>
                                        @foreach ($partnerships as $partnership)
                                            <option value="{{ $partnership->id }}" {{ old('partnership', $partnershipId) == $partnership->id ? "selected":"" }}>{{ $partnership->name }}</option>    
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group mr-2">
                                    <label for="cancelled"><small class="form-text text-muted">Estado</small></label>
                                    <select id="cancelled" name="status" class="form-control">
                                        <option value="T">Todos</option>
                                        <option value="V"
                                        @if (isset($status) && $status === 'V')
                                        selected
                                        @endif
                                        >Vigentes</option>
                                        <option value="C"
                                        @if (isset($status) && $status === 'C')
                                        selected
                                        @endif
                                        >Cancelados</option>
                                    </select>
                                </div>
                            </span>
                            <div class="d-flex">
                                <input type="search" name="filter" class="form-control" placeholder="Buscar ..." value="{{ old('filter', $filter) }}">
                                <button name="action" value="search" type="submit" class="btn btn-primary ml-2"><i class="fa fa-search"></i></button>
                            </div>
                        </th>
                    </tr>
                </thead>
                <thead class="thead-light">
                    <tr>
                        <th scope="col"><input id="select-all" type="checkbox"></th>
                        <th scope="col">No Empleado</th>
                        <th scope="col">Nombre</th>
                        <th scope="col">RFC</th>
                        <th scope="col">Curp</th>
                        <th scope="col">Consorcio</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($employees as $i)
                    <tr>
                        <th>
                            <input type="checkbox" name="selected[]" value="{{ $i->id }}">
                        </th>
                        <th scope="row">
                            <a href="/admin/employees/{{ $i->id }}/edit">{{ $i->employee_number }}</a>
                        </th>
                        <td>{{ $i->getFullName() }}</td>
                        <td>{{ $i->rfc }}</td>
                        <td>{{ $i->curp }}</td>
                        <td class="{{ $i->partnership->trashed() ? 'text-danger' : ''}}">{{ $i->partnership->name }}</td>
                    </tr>
                    @endforeach
                </tbody>
                <tfoot class="thead-light">
                    <tr>
                        <th scope="col" colspan="6">
                            <div class="btn-toolbar d-flex justify-content-end" role="toolbar">
                                <div class="btn-group" role="group">
                                    @foreach ($pages as $i)
                                        <button name="action" value="search-page" type="submit" class="btn btn-secondary {{ $i === $page ? 'active' : '' }}"
                                            onclick="$('#page-index').val({{ $i }})">{{ $i + 1 }}</button>
                                    @endforeach
                                    <input type="hidden" id="page-index" name="page-index" value="{{ $page }}">
                                </div>
                            </div>
                        </th>
                    </tr>
                </tfoot>
            </table>
        </form>
        @include('components.footer')
        <script src="/js/master-detail.js"></script>
    </body>
</html>
