<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    @include('components.head')
    <body>
        @component('components.nav')
            @slot('title')
                Empleados
            @endslot
        @endcomponent
        <form method="post" action="save" class="card" encType="multipart/form-data">
            @csrf
            @include('components.messages')
            <div class="card-header">
                <h5>
                    <table width="100%">
                        <tr>
                            <td>
                                @if ($record->id)
                                <input type="hidden" name="id" value="{{ $record->id }}">
                                @endif
                                <span>Número de empleado {{ $record->employee_number }}</span>
                            </td>
                            <td>
                                <div class="d-flex justify-content-end">
                                    <button type="button" class="btn btn-sm btn-secondary mr-2" data-toggle="modal" data-target="#change-partnership">
                                    <i class="fa fa-exchange-alt mr-2"></i>Cambiar de consorcio</a>
                                    </button>
                                </div>
                            </td>
                        </tr>
                    </table>

                </h5>
            </div>
            
            <div class="modal fade" id="change-partnership" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Cambiar consorcio</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-sm-12 col-md-12">
                                <div class="form-group">
                                    <label for="partnership">Consorcio</label>
                                    <select name="partnership" class="custom-select" id="partnership">
                                        @foreach ($partnerships as $partnership)
                                            <option value="{{ $partnership->id }}" {{ $record->partnership_id == $partnership->id ? "selected":"" }}>{{ $partnership->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button formmethod="POST" formaction="/admin/employees/{{ $record->id }}/change-partnership" name="action" value="{{ Session::token() }}" type="submit" class="btn btn-sm btn-success ml-2"><i class="fa fa-check mr-2"></i>Confirmar</button>
                    </div>
                    </div>
                </div>
            </div>


            @include('client/components/data-employee')
            
            <div class="card-footer d-flex justify-content-between">
                <a href="/admin/employees" class="btn btn-sm btn-secondary">
                    <i class="fas fa-chevron-left mr-2"></i>
                    <span>Regresar</span>
                </a>
                <span>
                    <button formmethod="POST" formaction="/admin/employees/{{ $record->id }}/store" name="action" value="{{ Session::token() }}" type="submit" class="btn btn-sm btn-success ml-2"><i class="fa fa-check mr-2"></i>Confirmar</button>
                </span>
            </div>
        </form>
        @include('components.footer')
        <script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
        <script>
            $(document).on('click', 'form button[type=submit]', function(e) {
                var accountType = $('#account-type').children("option:selected").val();
                var myLength = $('#account').val().length;
                if (myLength > 0) {
                    if (accountType == 'C' && myLength != 18) {
                        $('#account').addClass('border border-danger');
                        $('#account').focus();
                        return false;
                    } else if (accountType == 'T' && myLength != 16) {
                        $('#account').addClass('border border-danger');
                        $('#account').focus();
                        return false;
                    }
                }
            });
        </script>
    </body>
</html>
