<div class="modal fade" id="uploadWorkerFiles" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="staticBackdropLabel">Cargar comprobantes de pago</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <div class="modal-body">
                <div id="div-concepts" class="tab-pane fade show active">
                    <div class="row">
                        <div class="custom-file">
                            <input type="file" class="custom-file-input" id="voucher-file" name="voucher-file" aria-describedby="inputGroupFileAddon01">
                            <label class="custom-file-label" for="voucher-file"></label>
                        </div>
                    </div>
                    <div class="row" style="width: 100%; height: 400px; overflow-y: scroll;">
                        <div class="col-xs-12 col-md-12 mt-1">
                            <table class="table table-sm table-striped table-hover">
                                <thead class="thead-light">
                                    <tr>
                                        <th scope="col">
                                            <input id="select-all" type="checkbox">
                                        </th>
                                        <th scope="col" style="content-width">Empleado</th>
                                        <th scope="col" style="content-width">Monto</th>
                                        <th scope="col" style="content-width">Fecha de solicitud</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($employeeScatters as $employee)
                                        @foreach ($employee->scatterDetails as $detail)
                                            @if(!$detail->requestFile && $detail->isReleased())
                                            <tr>
                                                <td>
                                                    <input type="checkbox" name="employee-selected[]" value="{{ $detail->id }}">
                                                </td>
                                                <td>
                                                    {{$employee->employee->full_name}}
                                                </td>
                                                <td>
                                                    {{ '$' . number_format($detail->amount, 2) }}
                                                </td>
                                                <td>
                                                    {{ $detail->updated_at->format('d/m/Y H:m') }}
                                                </td>
                                            </tr>
                                            @endif
                                        @endforeach
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-sm btn-secondary" data-dismiss="modal">Cerrar</button>
                <button formmethod="POST" formaction="/requests/scatters/{{ $record->id }}/store-voucher" name="action" value="{{ Session::token() }}" type="submit" class="btn btn-sm btn-success ml-2"><i class="fa fa-check mr-2"></i>Confirmar</button>
            </div>
        </div>
    </div>
</div>
<script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bs-custom-file-input/dist/bs-custom-file-input.js" crossorigin="anonymous"></script>
<script type="text/javascript">
    $(function() {
        bsCustomFileInput.init();
    });
</script>