<div class="card">
    <div class="card-body">
        <ul class="nav nav-tabs">
            @foreach ($internalBusineses as $business)
            <li class="nav-item {{ $businessConceptActive == $business->code ? 'active' : '' }}"><a class="nav-link {{ $businessConceptActive == $business->code ? 'active' : '' }}" data-toggle="tab" href="#div-{{ $business->code }}">{{ $business->code }}</a></li>    
            @endforeach            
        </ul>
        <div class="tab-content">
            @foreach ($internalBusineses as $business)
            <div id="div-{{ $business->code }}" class="tab-pane fade {{ $businessConceptActive == $business->code ? 'show active' : '' }}">
                <div class="border rounded">
                    <table class="table table-sm table-striped table-hover">
                        <thead class="thead-light">
                            <tr>
                                <th>Código</th>
                                <th>Descripción</th>
                                <th>
                                    @if ($partnership->HasConcepts($business->id))
                                    <div class="input-group d-flex justify-content-end">
                                        <div class="input-group-append ">
                                            <button formmethod="POST" formaction="/admin/partnership-concepts/{{ $partnership->id }}/active/{{ $business->id }}" name="action" value="{{ Session::token() }}" id="btn-active" class="btn {{ $partnership->IsActive($business->id) ? 'btn-primary' : 'btn-secondary' }}" type="submit">Activo</button>
                                            <button formmethod="POST" formaction="/admin/partnership-concepts/{{ $partnership->id }}/desactive/{{ $business->id }}" name="action" value="{{ Session::token() }}" id="btn-desactive" class="btn {{ $partnership->IsActive($business->id) ? 'btn-secondary' : 'btn-primary' }}" type="submit">Desactivo</button>
                                        </div>
                                    </div>
                                    @endif
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($partnership->partnershipConcepts as $concept)
                            @if ($concept->business_client_id == $business->id)
                                <tr>
                                    <td><a href="/admin/partnership-concepts/{{ $concept->id }}/edit">{{ $concept->code }}</a></td>
                                    <td>{{ $concept->description }}</td>
                                    <td class="text-right">
                                        <button formmethod="POST" formaction="/admin/partnership-concepts/{{ $concept->id }}/destroy" name="action" value="{{ Session::token() }}" type="submit" class="btn btn-sm btn-danger ml-2"><i class="fa fa-minus"></i></button>
                                    </td>
                                </tr>
                            @endif
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="mt-2">
                    <a href="/admin/partnership-concepts/create/{{ $partnership->id }}/{{ $business->id }}" class="btn btn-sm btn-primary"><i class="fa fa-plus mr-2"></i>Agregar concepto</a>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</div>