<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    @include('components.head')
    <body>
        @component('components.nav')
            @slot('title')
                Creando concepto en 
            @endslot
        @endcomponent
        <form action="/admin/internal-business-clients" method="POST" class="container">
            @include('components.messages')
            {{ csrf_field() }}

            <input type="hidden" name="partnership-id" value="{{ $partnership->id }}">
            <input type="hidden" name="business-id" value="{{ $concept->business_client_id }}">
            @if (!empty($concept->id))    
                <input type="hidden" name="id" value="{{ $concept->id }}">
            @endif
            <div class="card">
                <div class="card-header">
                    <h5>Concepto de {{ $partnership->name }}</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-sm-12 col-md-12">
                            <div class="form-group">
                                <label for="business">Cliente interno</label>
                                <input class="form-control" id="business" name="business" value="{{ old('business', $business->code . ' - ' . $business->name)}}" 
                                    placeholder="Código del concepto" style="text-transform:uppercase" required disabled>
                                {!!$errors->first('business', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="code">Código</label>
                                <input class="form-control" id="code" name="code" value="{{ old('code', $concept->code)}}" 
                                    placeholder="Código del concepto" style="text-transform:uppercase" required autofocus>
                                {!!$errors->first('code', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-8">
                            <div class="form-group">
                                <label for="name">Nombre</label>
                                <input class="form-control" id="description" name="description" value="{{ old('description', $concept->description) }}" placeholder="Nombre del concepto" required>
                                {!!$errors->first('name', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex justify-content-between">
                    <a href="/admin/partnerships/{{ $partnership->id }}/edit/{{ $business->code }}" class="btn btn-sm btn-outline-secondary"><i class="fa fa-chevron-left mr-2"></i>Regresar</a>
                    <span>
                        <button formmethod="POST" formaction="/admin/partnership-concepts/store" name="_token" value="{{ Session::token() }}" type="submit" class="btn btn-sm btn-success ml-2"><i class="fa fa-check mr-2"></i>Confirmar</button>
                    </span>
                </div>
            </div>
        </form>
        @include('components.footer')
    </body>
</html>
