<div class="modal fade" id="editWorkerFiles" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="staticBackdropLabel">Editar comprobantes de pago</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <div class="modal-body">
                <div class="d-flex align-items-start">
                    <div class="nav flex-column nav-pills me-3" id="v-pills-tab" role="tablist" aria-orientation="vertical">
                        @foreach ($record->requestFilesDeposits as $file)
                            <a class="nav-link {{ $fileSelected == $file->id ? 'active' : '' }}" id="{{ 'div-file-' . $file->id . '-tab'}}" data-bs-toggle="pill" href="#{{ 'div-file-' . $file->id }}" role="tab" aria-controls="{{ 'div-file-' . $file->id }}" aria-selected="{{ $fileSelected == $file->id ? 'true' : 'false' }}">{{ $file->name_file }}</a>
                        @endforeach
                    </div>
                    <div class="tab-content" id="v-pills-tabContent">
                        @foreach ($record->requestFilesDeposits as $file)
                            <div class="edit-worker-files tab-pane fade {{ $fileSelected == $file->id ? 'show active' : '' }}" id="{{ 'div-file-' . $file->id }}" role="tabpanel" aria-labelledby="{{ 'div-file-' . $file->id . '-tab' }}">
                                <div style="width: 100%; height: 400px; overflow-y: scroll;">
                                <table class="table table-sm table-striped table-hover">
                                    <thead class="thead-light">
                                        <tr>
                                            <th scope="col">
                                                <input id="select-all" type="checkbox" class="custom-control-input-{{ $file->id }}">
                                            </th>
                                            <th scope="col" style="content-width">Empleado</th>
                                            <th scope="col" style="content-width">Monto</th>
                                            <th scope="col" style="content-width">Fecha de solicitud</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($employeeScatters as $employee)
                                            @foreach ($employee->scatterDetails as $detail)
                                                @if(($detail->request_file_id && $detail->request_file_id == $file->id) || (!$detail->requestFile && $detail->isReleased()))
                                                <tr>
                                                    <td>
                                                        <input type="checkbox" class="custom-control-input-{{ $file->id }}" name="employee-selected-{{$file->id}}[]" value="{{ $detail->id }}" {{ $detail->requestFile && $detail->requestFile->id == $file->id ? 'checked' : ''}}>
                                                    </td>
                                                    <td>
                                                        {{$employee->employee->full_name}}
                                                    </td>
                                                    <td>
                                                        {{ '$' . number_format($detail->amount, 2) }}
                                                    </td>
                                                    <td>
                                                        {{ $detail->updated_at->format('d/m/Y H:m') }}
                                                    </td>
                                                </tr>
                                                @endif
                                            @endforeach
                                        @endforeach
                                    </tbody>
                                </table>
                                </div>
                                <div class="card-footer d-flex justify-content-between">
                                    <button formmethod="POST" formaction="/requests/scatters/{{ $file->id }}/edit-voucher" name="action" value="{{ Session::token() }}" type="submit" class="btn btn-sm btn-success ml-2">
                                        <i class="fa fa-check mr-2"></i>Confirmar
                                    </button>
                                    <button formmethod="POST" formaction="/requests/scatters/{{ $file->id }}/destroy-voucher" name="action" value="{{ Session::token() }}" type="submit" class="btn btn-sm btn-danger ml-2">
                                        <i class="fa fa-trash mr-2"></i>Eliminar
                                    </button>
                                </div>
                            </div>                                                        
                        @endforeach
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-sm btn-secondary" data-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>
<script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
<script type="text/javascript">
    $(function() {
        $(".nav-link" ).click(function() {
            $('.nav-link').each(function() {
                $(this).removeClass("active");
            });
            $(this).addClass("active");

            $('.edit-worker-files').each(function() {
                $(this).removeClass("show");
                $(this).removeClass("active");
            });
            $('#' + $(this).attr("aria-controls")).addClass('show');
            $('#' + $(this).attr("aria-controls")).addClass('active');
        });
    });
</script>