<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    @include('components.head')
    <body>
        @component('components.nav')
            @slot('title')
                Departamento
            @endslot
        @endcomponent
        <form action="/admin/internal-business-clients" method="POST" class="container">
            @include('components.messages')
            {{ csrf_field() }}

            @if (!empty($business->id))
                <input type="hidden" name="id" value="{{$business->id}}">
                <input type="hidden" name="departmentId" value="{{$department->id}}">
            @endif
            <div class="card">
                <div class="card-header">
                    <h5>Departamento de {{ $business->name }}</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="code">Código</label>
                                <input class="form-control" id="code" name="code" value="{{ old('code', $department->code)}}" autofocus
                                    placeholder="Código del departamento" style="text-transform:uppercase" required>
                                {!!$errors->first('code', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-8">
                            <div class="form-group">
                                <label for="name">Nombre</label>
                                <input class="form-control" id="name" name="name" value="{{ old('name', $department->name)}}" placeholder="Nombre del departamento" required>
                                {!!$errors->first('name', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="rfc">Email</label>
                                <input class="form-control" id="email" name="email" value="{{ old('email', $department->email)}}" placeholder="Email del departamento" required>
                                {!!$errors->first('email', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="rfc">Prefijo de folios para timbrar</label>
                                <input class="form-control" id="prefix" name="prefix" value="{{ old('prefix', $department->prefix)}}" maxlength="5"
                                    placeholder="Prefijo del departamento"  style="text-transform:uppercase" required>
                                {!!$errors->first('prefix', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex justify-content-between">
                    <a href="/admin/internal-business-clients/{{$business->id}}/edit" class="btn btn-sm btn-outline-secondary"><i class="fa fa-chevron-left mr-2"></i>Regresar</a>
                    <span>
                        @if ($business->id && $business->id > 0)
                            <button name="action" value="destroy-department" type="submit" class="btn btn-sm btn-danger ml-2"><i class="fa fa-trash mr-2"></i>Eliminar departamento</button>
                        @endif
                        <button name="action" value="store-department" type="submit" class="btn btn-sm btn-success ml-2"><i class="fa fa-check mr-2"></i>Confirmar</button>
                    </span>
                </div>
            </div>
        </form>
        @include('components.footer')
    </body>
</html>
