<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    @include('components.head')
    <body>
        @component('components.nav')
            @slot('title')
                Creando concepto
            @endslot
        @endcomponent
        <form action="/admin/internal-business-clients" method="POST" class="container">
            @include('components.messages')
            {{ csrf_field() }}

            @if (!empty($business->id))
                <input type="hidden" name="id" value="{{$business->id}}">
                <input type="hidden" name="conceptId" value="{{$concept->id}}">
            @endif
            <div class="card">
                <div class="card-header">
                    <h5>Concepto de {{ $business->name }}</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="code">Código</label>
                                <input class="form-control" id="code" name="code" value="{{ old('code', $concept->code)}}" 
                                    placeholder="Código del concepto" style="text-transform:uppercase" required>
                                {!!$errors->first('code', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-8">
                            <div class="form-group">
                                <label for="name">Nombre</label>
                                <input class="form-control" id="name" name="name" value="{{ old('name', $concept->name)}}" placeholder="Nombre del concepto" required>
                                {!!$errors->first('name', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="type">Tipo</label>
                                <select id="type" name="type" class="form-control" required>
                                    <option value="C" {{ old('type', $concept->type) == 'C' ? 'selected' : '' }}>Aplica a clientes</option>
                                    <option value="S" {{ old('type', $concept->type) == 'S' ? 'selected' : '' }}>Especial</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex justify-content-between">
                    <a href="/admin/internal-business-clients/{{$business->id}}/edit" class="btn btn-sm btn-outline-secondary"><i class="fa fa-chevron-left mr-2"></i>Regresar</a>
                    <span>
                        @if ($concept->id && $concept->id > 0)
                            <button formmethod="POST" formaction="/admin/business-concepts/destroy" name="_token" value="{{ Session::token() }}" type="submit" class="btn btn-sm btn-danger ml-2"><i class="fa fa-trash mr-2"></i>Eliminar concepto</button>
                        @endif
                        <button formmethod="POST" formaction="/admin/business-concepts/store" name="_token" value="{{ Session::token() }}" type="submit" class="btn btn-sm btn-success ml-2"><i class="fa fa-check mr-2"></i>Confirmar</button>
                    </span>
                </div>
            </div>
        </form>
        @include('components.footer')
    </body>
</html>
