<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    @include('components.head')
    <body>
        @component('components.nav')
            @slot('title')
                Clientes internos
            @endslot
        @endcomponent
        <form action="/admin/internal-business-clients" method="POST" class="container">
            @include('components.messages')
            {{ csrf_field() }}

            @if (!empty($business->id))
                <input type="hidden" name="id" value="{{$business->id}}">
            @endif
            <div class="card">
                <div class="card-header">
                    <h5>Cliente interno</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="code">Código</label>
                                <input class="form-control" id="code" name="code" value="{{ old('code', $business->code)}}"
                                    placeholder="Código del cliente" style="text-transform:uppercase" required>
                                {!!$errors->first('code', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="name">Nombre</label>
                                <input class="form-control" id="name" name="name" value="{{ old('name', $business->name)}}" placeholder="Nombre del cliente" required>
                                {!!$errors->first('name', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="name">Registro patronal</label>
                                <input class="form-control" id="employer_registration" name="employer_registration" value="{{ old('name', $business->employer_registration)}}" placeholder="Registro patronal">
                                {!!$errors->first('employer_registration', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="rfc">RFC</label>
                                <input class="form-control" id="rfc" name="rfc" value="{{ old('rfc', $business->rfc)}}"
                                    placeholder="Rfc del cliente" maxlength="13" style="text-transform:uppercase" required>
                                {!!$errors->first('rfc', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="prefix">Prefijo de folios para timbrar</label>
                                <input class="form-control" id="prefix" name="prefix" value="{{ old('prefix', $business->prefix)}}" maxlength="5"
                                    placeholder="Prefijo del cliente" style="text-transform:uppercase" required>
                                {!!$errors->first('prefix', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                            </div>
                        </div>
                        <div class="col-md-4">
                            <label for="image">Nombre de imagen</label>
                            <input class="form-control" id="image" name="image" value="{{ old('image', $business->image) }}" maxlength="250" placeholder="Nombre de imagen">
                        </div>
                    </div>
                    <ul class="nav nav-tabs">
                        <li class="nav-item active"><a class="nav-link active" data-toggle="tab" href="#div-concepts">Conceptos</a></li>
                        <li class="nav-item"><a class="nav-link" data-toggle="tab" href="#div-special-concepts">Conceptos especiales</a></li>
                        <li class="nav-item"><a class="nav-link" data-toggle="tab" href="#div-branches">Lugares de expedición</a></li>
                    </ul>
                    <div class="tab-content">
                        <div id="div-concepts" class="tab-pane fade show active">
                            <div class="border rounded">
                                <table class="table table-sm table-striped table-hover">
                                    <thead class="thead-light">
                                        <tr>
                                            <th>Código</th>
                                            <th>Nombre</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($clientConcepts as $i)
                                        <tr>
                                            <th scope="row">
                                                <a href="/admin/business-concepts/{{ $i->id }}/edit">{{ $i->code }}</a>
                                            </th>
                                            <td>{{ $i->name }}</td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            <div class="mt-2">
                                @if ($business->id && $business->id > 0)
                                <a href="/admin/business-concepts/create/{{$business->id}}" class="btn btn-sm btn-primary mr-2"><i class="fa fa-plus mr-2"></i>Agregar concepto</a>
                                @endif
                            </div>
                        </div>
                        <div id="div-special-concepts" class="tab-pane fade">
                            <div class="border rounded">
                                <table class="table table-sm table-striped table-hover">
                                    <thead class="thead-light">
                                        <tr>
                                            <th>Código</th>
                                            <th>Nombre</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($specialConcepts as $i)
                                        <tr>
                                            <th scope="row">
                                                <a href="/admin/business-concepts/{{ $i->id }}/edit">{{ $i->code }}</a>
                                            </th>
                                            <td>{{ $i->name }}</td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            <div class="mt-2">
                                @if ($business->id && $business->id > 0)
                                <a href="/admin/business-concepts/create/{{$business->id}}" class="btn btn-sm btn-primary mr-2"><i class="fa fa-plus mr-2"></i>Agregar concepto</a>
                                @endif
                            </div>
                        </div>
                        <div id="div-branches" class="tab-pane fade">
                            <div class="border rounded">
                                <table class="table table-sm table-striped table-hover">
                                    <thead class="thead-light">
                                        <tr>
                                            <th>Nombre</th>
                                            <th>Prefijo</th>
                                            <th>Código postal</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($business->branches as $b)
                                        <tr>
                                            <th scope="row">
                                                <a href="/admin/business-branches/{{ $b->id }}/edit">{{ $b->name }}</a>
                                            </th>
                                            <td>{{ $b->prefix }}</td>
                                            <td>{{ $b->postal_code }}</td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            <div class="mt-2">
                                @if ($business->id && $business->id > 0)
                                <a href="/admin/business-branches/create/{{$business->id}}" class="btn btn-sm btn-primary mr-2"><i class="fa fa-plus mr-2"></i>Agregar lugar de expedición</a>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex justify-content-between">
                    <a href="/admin/internal-business-clients" class="btn btn-sm btn-outline-secondary mr-2"><i class="fa fa-chevron-left mr-2"></i>Regresar</a>
                    <button formmethod="POST" formaction="/admin/internal-business-clients/store" name="action" value="{{ Session::token() }}" type="submit" class="btn btn-sm btn-success ml-2"><i class="fa fa-check mr-2"></i>Confirmar</button>
                </div>
            </div>
        </form>
        @include('components.footer')
    </body>
</html>
