<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    @include('components.head')
    <body>
        @component('components.nav')
            @slot('title')
                Clientes internos
            @endslot
        @endcomponent
        <form action="/admin/internal-business-clients" method="POST" class="container-fluid">
            {{ csrf_field() }}
            @include('components.messages')
            <table class="table border">
                <thead class="thead-light">
                    <tr>
                        <th scope="col" colspan="3">
                            <span>
                                <a href="/admin/internal-business-clients/create" class="btn btn-sm btn-primary back mr-5" role="button">
                                    <i class="fa fa-plus mr-2"></i>Agregar cliente interno</a>
                                <button type="submit" formmethod="POST" formaction="/admin/internal-business-clients/destroy" data-toggle="modal" class="btn btn-sm btn-danger back" name="action" value="destroy">
                                    <i class="fa fa-trash mr-2"></i>Dar de baja cliente
                                </button>
                            </span>
                        </th>
                        <th scope="col" class="text-right">
                            Número de clientes: <strong>{{ $total }}</strong>
                        </th>
                    </tr>
                </thead>
                <thead class="thead-light">
                    <tr>
                        <th scope="col" colspan="4">
                            <span class="d-flex">
                                <div class="form-group mr-4">
                                    <label for="cancelled"><small class="form-text text-muted">Estado</small></label>
                                    <select id="cancelled" name="status" class="form-control">
                                        <option value="V"
                                        @if (isset($status) && $status === 'V')
                                        selected
                                        @endif
                                        >Vigentes</option>
                                        <option value="C"
                                        @if (isset($status) && $status === 'C')
                                        selected
                                        @endif
                                        >Cancelados</option>
                                    </select>
                                </div>
                            </span>
                            <div class="d-flex">
                                <input type="search" name="filter" class="form-control" placeholder="Buscar ..." value="{{ old('filter', $filter) }}">
                                <button name="action" value="search" type="submit" class="btn btn-primary ml-2"><i class="fa fa-search"></i></button>
                            </div>
                        </th>
                    </tr>
                </thead>
                <thead class="thead-light">
                    <tr>
                        <th scope="col"><input id="select-all" type="checkbox"></th>
                        <th scope="col">Código</th>
                        <th scope="col">Nombre</th>
                        <th scope="col">RFC</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($businessClients as $i)
                    <tr>
                        <th>
                            <input type="checkbox" name="selected[]" value="{{ $i->id }}">
                        </th>
                        <th scope="row">
                            <a href="/admin/internal-business-clients/{{ $i->id }}/edit">{{ $i->code }}</a>
                        </th>
                        <td>{{ $i->name }}</td>
                        <td>{{ $i->rfc }}</td>
                    </tr>
                    @endforeach
                </tbody>
                <tfoot class="thead-light">
                    <tr>
                        <th scope="col" colspan="6">
                            <div class="btn-toolbar d-flex justify-content-end" role="toolbar">
                                <div class="btn-group" role="group">
                                    @foreach ($pages as $i)
                                        <button name="action" value="search-page" type="submit" class="btn btn-secondary {{ $i === $page ? 'active' : '' }}"
                                            onclick="$('#page-index').val({{ $i }})">{{ $i + 1 }}</button>
                                    @endforeach
                                    <input type="hidden" id="page-index" name="page-index" value="{{ $page }}">
                                </div>
                            </div>
                        </th>
                    </tr>
                </tfoot>
            </table>
        </form>
        @include('components.footer')
        <script src="/js/master-detail.js"></script>
    </body>
</html>
