<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    @include('components.head')
    <body>
        @component('components.nav')
            @slot('title')
                Creando concepto
            @endslot
        @endcomponent
        <form action="/admin/internal-business-clients" method="POST" class="container">
            @include('components.messages')
            {{ csrf_field() }}

            @if (!empty($business->id))
                <input type="hidden" name="id" value="{{$business->id}}">
                <input type="hidden" name="branchId" value="{{$branch->id}}">
            @endif
            <div class="card">
                <div class="card-header">
                    <h5>Lugar de expedición de {{ $business->name }}</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="name">Nombre</label>
                                <input class="form-control" id="name" name="name" value="{{ old('name', $branch->name)}}" 
                                    placeholder="Nombre" required>
                                {!!$errors->first('name', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="name">Prefijo</label>
                                <input class="form-control" id="prefix" name="prefix" value="{{ old('prefix', $branch->prefix)}}" placeholder="Prefijo" required>
                                {!!$errors->first('name', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="form-group">
                                <label for="name">Código postal</label>
                                <input class="form-control" id="postal-code" name="postal-code" value="{{ old('postal-code', $branch->postal_code)}}" placeholder="Código postal" required>
                                {!!$errors->first('name', '<div class="alert alert-danger alert-dismissible fade show">:message</div>')!!}
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex justify-content-between">
                    <a href="/admin/internal-business-clients/{{$business->id}}/edit" class="btn btn-sm btn-outline-secondary"><i class="fa fa-chevron-left mr-2"></i>Regresar</a>
                    <span>
                        @if ($business->id && $business->id > 0)
                            <button formmethod="POST" formaction="/admin/business-branches/destroy" name="action" value="destroy-branch" type="submit" class="btn btn-sm btn-danger ml-2"><i class="fa fa-trash mr-2"></i>Eliminar lugar de expedición</button>
                        @endif
                        <button formmethod="POST" formaction="/admin/business-branches/store" name="action" value="{{ Session::token() }}" type="submit" class="btn btn-sm btn-success ml-2"><i class="fa fa-check mr-2"></i>Confirmar</button>
                    </span>
                </div>
            </div>
        </form>
        @include('components.footer')
    </body>
</html>
