<?php

use App\Model\ConfigCodes;
use App\Model\Employee;
use App\Model\Partnership;
use Illuminate\Database\Seeder;

class ResetEmployeesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Employee::truncate();
        ConfigCodes::where('pattern', 'like', '.%')->delete();

        $data = array(
            array('code' => 'YIELD', 'name' => 'AGROSERVICIOS INDUSTRIALES ORBE SA DE CV', 'prefix' => '1'),
            array('code' => 'LLASA', 'name' => 'LLANTAS Y ADITAMIENTOS SA DE CV', 'prefix' => '2'),
            array('code' => 'ICAYS', 'name' => 'INGENIERIA DE CONTROL AMBIENTAL Y SANEAMIENTO SA DE CV', 'prefix' => '3'),
            array('code' => 'ACG', 'name' => 'ACG GLOBAL SA DE CV', 'prefix' => '4'),
            array('code' => 'TALLERES', 'name' => 'TALLERES MECANICOS MANUFACTUREROS S.A. DE C.V.', 'prefix' => '5'),
            array('code' => 'DISTRIBUIDORES', 'name' => 'DISTRIBUIDORES ASOCIADOS DE LA REPUBLICA SA DE CV', 'prefix' => '6'),
            array('code' => 'BB', 'name' => 'BB DESPACHO INTEGRAL DE SERVICIOS SA DE CV', 'prefix' => '7'),
            array('code' => 'DAISYTEK', 'name' => 'GRUPO DAISYTEK SA DE CV', 'prefix' => '8'),
            array('code' => 'TRANSMOCASA', 'name' => 'TRANSMOCASA SA DE CV', 'prefix' => '9'),
            array('code' => 'SAUBER', 'name' => 'SAUBER Y FERTING DE MEXICO SA DE CV', 'prefix' => '10'),
            array('code' => 'NOLBELTS', 'name' => 'NOLBELTS', 'prefix' => '11'),
            array('code' => 'NOVAMEDIA', 'name' => 'NOVAMEDIA', 'prefix' => '12'),
            array('code' => 'BURGUETE', 'name' => 'RODOLGO BURGUETE', 'prefix' => '13'),
            array('code' => 'MINIMALISTA', 'name' => 'MINIMALISTA', 'prefix' => '14'),
            array('code' => 'ENGINEERING', 'name' => 'ENGINEERING', 'prefix' => '15'),
            array('code' => 'CLINICA', 'name' => 'CLINICA', 'prefix' => '16'),
            array('code' => 'SELKAR', 'name' => 'GRUPO SELKAR S.A. DE C.V', 'prefix' => '17')
        );
        Partnership::insert($data);
    }
}
