<?php

use App\Model\Authorization;
use App\Model\Bank;
use App\Model\CategoryAuthorization;
use Illuminate\Database\Seeder;

class RequestTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $data = [
            ['name' => 'Solicitudes', 'index' => 4]
        ];
        CategoryAuthorization::insert($data);

        $admin = CategoryAuthorization::where('name', 'Solicitudes')->first();
        $data = [
            ['code' => 'SCATTER_REQUESTS', 'name' => 'Dispersión de nómina',
                'index' => 100, 'category_authorization_id' => $admin->id],
            ['code' => 'BUSINESS_REQUESTS', 'name' => 'Alta de empresas',
                'index' => 200, 'category_authorization_id' => $admin->id],
            ['code' => 'WORKER_REQUESTS', 'name' => 'Alta de trabajadores',
                'index' => 300, 'category_authorization_id' => $admin->id],
            ['code' => 'COLLABORATOR_REQUESTS', 'name' => 'Alta de colaboradores',
                'index' => 400, 'category_authorization_id' => $admin->id]
        ];
        Authorization::insert($data);

        $data = [
            ['name' => 'Prudential Bank']
        ];
        Bank::insert($data);
    }
}
