<?php

use App\Model\BusinessClient;
use App\Model\BusinessClientConcept;
use App\Model\InvoicePayType;
use App\Model\InvoiceProduct;
use App\Model\InvoiceTaxRegimes;
use App\Model\InvoiceType;
use App\Model\InvoiceUse;
use Illuminate\Database\Seeder;

class InvoiceCatalogTablesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        if (BusinessClient::where('code', 'CAOC7704038C6')->count() == 0) {
            $data = array(
                array('type' => 'E', 'code' => 'CAOC7704038C6', 'rfc' => 'CAOC7704038C6', 'name' => 'CARLOS EDUARDO CAMPOS OROPEZA', 'address' => 'AV. JUAREZ 2925 COL. LA PAZ.'),
                array('type' => 'E', 'code' => 'IET0701246J3', 'rfc' => 'IET0701246J3', 'name' => 'INNOVACION EN TERMOFORMADO S.A DE C.V.', 'address' => 'AV. DEL MARQUES 38 PARQUE INDUSTRIAL BERNARDO QUINTANA C.P. 76240 EL MARQUES EL MARQUES QUERETARO'),
                array('type' => 'E', 'code' => 'SIC180106BP7', 'rfc' => 'SIC180106BP7', 'name' => 'SERVICIOS INTEGRALES DE CONSTRUCCIÓN MANTENIMIENTO EMERGENCIA Y RESCATE SA DE CV', 'address' => 'AV. CESAR SANDINO 462 INT.1 C.P. 86190, PRIMERO DE MAYO, VILLAHERMOSA TABASCO, MÉXICO'),
                array('type' => 'E', 'code' => 'SMO100609T12', 'rfc' => 'SMO100609T12', 'name' => '7 MOON SA DE CV', 'address' => 'CALLE CARLOS J BARRIOS No. 220 INTERIOR A COL. VOLCANES DEL SUR PUEBLA, PUE'),
                array('type' => 'E', 'code' => 'AIX120627EL9', 'rfc' => 'AIX120627EL9', 'name' => 'ACCIVIM I SAPI DE CV', 'address' => 'BLVD. CAMPESTRE No. 2905 INTERIOR 204, COL. RESIDENCIAL CAMPESTRE, LEON GUANAJUATO, MEXICO, CP 37156'),
                array('type' => 'E', 'code' => 'AGL011218HP1', 'rfc' => 'AGL011218HP1', 'name' => 'ACG GLOBAL S.A. DE C.V.', 'address' => ''),
                array('type' => 'E', 'code' => 'AGL011218HP1', 'rfc' => 'AGL011218HP1', 'name' => 'ACG GLOBAL SA DE CV', 'address' => 'CALLE PEÑA 10 MANZANA 9 LOTE 10 A y B,SUPERMANZANA 48, COL. LAS PEÑAS , QUINTANA ROO, 77506'),
                array('type' => 'E', 'code' => 'AIN050216TY6', 'rfc' => 'AIN050216TY6', 'name' => 'AF INSTALACIONES S.A. DE C.V.', 'address' => ''),
                array('type' => 'E', 'code' => 'AIO1408079C4', 'rfc' => 'AIO1408079C4', 'name' => 'AGROSERVICIOS INDUSTRIALES ORBE S.A. DE C.V.', 'address' => ''),
                array('type' => 'E', 'code' => 'XAXX010101000', 'rfc' => 'XAXX010101000', 'name' => 'ALEJANDRA LEDEZMA ORTEGA', 'address' => 'Constitucion No.12, Col. Centro, Leon Gto. 37000'),
                array('type' => 'E', 'code' => 'MEAA6301095M4', 'rfc' => 'MEAA6301095M4', 'name' => 'Alejandro Meneses Acosta', 'address' => 'Av. 5 de Febrero Núm. Exterior 9100 Local 6 Colonia Zona Industrial Benito Juarez C.P. 76120 Querétaro, Qro.')
            );
            BusinessClient::insert($data);
        }

        if (InvoicePayType::count() == 0) {
            $data = array(
                array('code' => '01', 'description' => 'Efectivo'),
                array('code' => '02', 'description' => 'Cheque nominativo'),
                array('code' => '03', 'description' => 'Transferencia electrónica de fondos'),
                array('code' => '04', 'description' => 'Tarjeta de crédito'),
                array('code' => '05', 'description' => 'Monedero electrónico'),
                array('code' => '06', 'description' => 'Dinero electrónico'),
                array('code' => '08', 'description' => 'Vales de despensa'),
                array('code' => '12', 'description' => 'Dación en pago'),
                array('code' => '13', 'description' => 'Pago por subrogación'),
                array('code' => '14', 'description' => 'Pago por consignación'),
                array('code' => '15', 'description' => 'Condonación'),
                array('code' => '17', 'description' => 'Compensación'),
                array('code' => '23', 'description' => 'Novación'),
                array('code' => '24', 'description' => 'Confusión'),
                array('code' => '25', 'description' => 'Remisión de deuda'),
                array('code' => '26', 'description' => 'Prescripción o caducidad'),
                array('code' => '27', 'description' => 'A satisfacción del acreedor'),
                array('code' => '28', 'description' => 'Tarjeta de débito'),
                array('code' => '29', 'description' => 'Tarjeta de servicios'),
                array('code' => '30', 'description' => 'Aplicación de anticipos'),
                array('code' => '31', 'description' => 'Intermediario pagos'),
                array('code' => '99', 'description' => 'Por definir')
            );
            InvoicePayType::insert($data);
        }

        if (InvoiceTaxRegimes::count() == 0) {
            $data = array(
                array('code' => '601', 'description' => 'General de Ley Personas Morales'),
                array('code' => '603', 'description' => 'Personas Morales con Fines no Lucrativos'),
                array('code' => '605', 'description' => 'Sueldos y Salarios e Ingresos Asimilados a Salarios'),
                array('code' => '606', 'description' => 'Arrendamiento'),
                array('code' => '608', 'description' => 'Demás ingresos'),
                array('code' => '609', 'description' => 'Consolidación'),
                array('code' => '610', 'description' => 'Residentes en el Extranjero sin Establecimiento Permanente en México'),
                array('code' => '611', 'description' => 'Ingresos por Dividendos (socios y accionistas)'),
                array('code' => '612', 'description' => 'Personas Físicas con Actividades Empresariales y Profesionales'),
                array('code' => '614', 'description' => 'Ingresos por intereses'),
                array('code' => '616', 'description' => 'Sin obligaciones fiscales'),
                array('code' => '620', 'description' => 'Sociedades Cooperativas de Producción que optan por diferir sus ingresos'),
                array('code' => '621', 'description' => 'Incorporación Fiscal'),
                array('code' => '622', 'description' => 'Actividades Agrícolas, Ganaderas, Silvícolas y Pesqueras'),
                array('code' => '623', 'description' => 'Opcional para Grupos de Sociedades'),
                array('code' => '624', 'description' => 'Coordinados'),
                array('code' => '628', 'description' => 'Hidrocarburos'),
                array('code' => '607', 'description' => 'Régimen de Enajenación o Adquisición de Bienes'),
                array('code' => '629', 'description' => 'De los Regímenes Fiscales Preferentes y de las Empresas Multinacionales'),
                array('code' => '630', 'description' => 'Enajenación de acciones en bolsa de valores'),
                array('code' => '615', 'description' => 'Régimen de los ingresos por obtención de premios')
            );
            InvoiceTaxRegimes::insert($data);
        }

        if (InvoiceType::count() == 0) {
            $data = array(
                array('code' => 'I', 'description' => 'Ingreso'),
                array('code' => 'E', 'description' => 'Egreso'),
                array('code' => 'T', 'description' => 'Traslado'),
                array('code' => 'N', 'description' => 'Nómina'),
                array('code' => 'P', 'description' => 'Pago')
            );
            InvoiceType::insert($data);
        }

        if ( InvoiceUse::count() == 0 ) {
            $data = array(
                array('code' => 'G01', 'description' => 'Adquisición de mercancias'),
                array('code' => 'G02', 'description' => 'Devoluciones, descuentos o bonificaciones'),
                array('code' => 'G03', 'description' => 'Gastos en general'),
                array('code' => 'I01', 'description' => 'Construcciones'),
                array('code' => 'I02', 'description' => 'Mobilario y equipo de oficina por inversiones'),
                array('code' => 'I03', 'description' => 'Equipo de transporte'),
                array('code' => 'I04', 'description' => 'Equipo de computo y accesorios'),
                array('code' => 'I05', 'description' => 'Dados, troqueles, moldes, matrices y herramental'),
                array('code' => 'I06', 'description' => 'Comunicaciones telefónicas'),
                array('code' => 'I07', 'description' => 'Comunicaciones satelitales'),
                array('code' => 'I08', 'description' => 'Otra maquinaria y equipo'),
                array('code' => 'D01', 'description' => 'Honorarios médicos, dentales y gastos hospitalarios.'),
                array('code' => 'D02', 'description' => 'Gastos médicos por incapacidad o discapacidad'),
                array('code' => 'D03', 'description' => 'Gastos funerales.'),
                array('code' => 'D04', 'description' => 'Donativos.'),
                array('code' => 'D05', 'description' => 'Intereses reales efectivamente pagados por créditos hipotecarios (casa habitación).'),
                array('code' => 'D06', 'description' => 'Aportaciones voluntarias al SAR.'),
                array('code' => 'D07', 'description' => 'Primas por seguros de gastos médicos.'),
                array('code' => 'D08', 'description' => 'Gastos de transportación escolar obligatoria.'),
                array('code' => 'D09', 'description' => 'Depósitos en cuentas para el ahorro, primas que tengan como base planes de pensiones.'),
                array('code' => 'D10', 'description' => 'Pagos por servicios educativos (colegiaturas)'),
                array('code' => 'P01', 'description' => 'Por definir')
            );
            InvoiceUse::insert($data);
        }
        
        $client = BusinessClient::where('code', 'COMERSOLUTIONS')
            ->whereNull('canceled_at')
            ->where('type', 'I')
            ->first();
        if ($client && BusinessClientConcept::
                where('business_client_id', $client->id)
                ->count() == 0) {
            $data = array(
                array('code' => '84111601', 'name' => 'Auditorias de cierre del ejercicio', 'business_client_id' => $client->id),
                array('code' => '84111602', 'name' => 'Revisiones trimestrales', 'business_client_id' => $client->id),
                array('code' => '84111603', 'name' => 'Auditorias internas de IVA', 'business_client_id' => $client->id),
                array('code' => '84111603', 'name' => 'Auditorias internas de ISR', 'business_client_id' => $client->id),
                array('code' => '84111603', 'name' => 'Auditorias internas de control interno.', 'business_client_id' => $client->id),
                array('code' => '84111603', 'name' => 'Auditorias internas para el control de cuentas por cobrar', 'business_client_id' => $client->id),
                array('code' => '84111603', 'name' => 'Auditorias internas para el control de cuentas por pagar', 'business_client_id' => $client->id),
                array('code' => '84111603', 'name' => 'Auditorias internas para el control de cuentas por cobrar y por pagar', 'business_client_id' => $client->id),
                array('code' => '80111505', 'name' => 'Auditorías de productividad de los recursos humanos', 'business_client_id' => $client->id),
                array('code' => '80111505', 'name' => 'Auditorías de productividad del capital humano', 'business_client_id' => $client->id),
                array('code' => '80161602', 'name' => 'Servicios de inventariado', 'business_client_id' => $client->id),
                array('code' => '81141500', 'name' => 'Servicios de control de calidad', 'business_client_id' => $client->id),
                array('code' => '84111801', 'name' => 'Gestores fiscales', 'business_client_id' => $client->id),
                array('code' => '84111603', 'name' => 'Auditorias internas de calidad', 'business_client_id' => $client->id)
            );
            BusinessClientConcept::insert($data);
        }

        $client = BusinessClient::where('code', 'COMERPUEPLUS')
            ->whereNull('canceled_at')
            ->where('type', 'I')
            ->first();
        if ($client && BusinessClientConcept::
                where('business_client_id', $client->id)
                ->count() == 0) {
            $data = array(
                array('code' => '86101705', 'name' => 'Capacitación administrativa', 'business_client_id' => $client->id),
                array('code' => '80101500', 'name' => 'Servicios de consultoría de negocios y administración corporativa', 'business_client_id' => $client->id),
                array('code' => '80101502', 'name' => 'Servicios de asesoramiento sobre fusiones de empresas', 'business_client_id' => $client->id),
                array('code' => '80101504', 'name' => 'Servicios de asesoramiento sobre planificación estratégica', 'business_client_id' => $client->id),
                array('code' => '80101505', 'name' => 'Consultoría en políticas u objetivos empresariales', 'business_client_id' => $client->id),
                array('code' => '80101506', 'name' => 'Consultoría en estructuras organizacionales', 'business_client_id' => $client->id),
                array('code' => '80101600', 'name' => 'Gerencia de proyectos', 'business_client_id' => $client->id),
                array('code' => '80101601', 'name' => 'Estudios de factibilidad o selección de ideas de proyectos', 'business_client_id' => $client->id),
                array('code' => '80101604', 'name' => 'Planificación o administración de proyectos', 'business_client_id' => $client->id),
                array('code' => '80101605', 'name' => 'Servicios de elaboración de proyectos', 'business_client_id' => $client->id),
                array('code' => '80101501', 'name' => 'Consultoría para la apertura de nuevas empresas', 'business_client_id' => $client->id),
                array('code' => '80101501', 'name' => 'Servicios de asesoramiento sobre la puesta en marcha de empresas nuevas', 'business_client_id' => $client->id),
                array('code' => '80141626', 'name' => 'Servicio de administración de programas promocionales', 'business_client_id' => $client->id),
                array('code' => '80141626', 'name' => 'Servicio de gestión de programas promocionales', 'business_client_id' => $client->id),
                array('code' => '80111501', 'name' => 'Perfeccionamiento de la función de gestión ', 'business_client_id' => $client->id),
                array('code' => '80111501', 'name' => 'Servicios de mejoras en las habilidades de gestión', 'business_client_id' => $client->id),
                array('code' => '80111510', 'name' => 'Servicio de redacción y desarrollo de la descripción de puestos de trabajo', 'business_client_id' => $client->id),
                array('code' => '80161502', 'name' => 'Servicios de planificación de reuniones', 'business_client_id' => $client->id),
                array('code' => '80101603', 'name' => 'Evaluación económica de proyectos', 'business_client_id' => $client->id),
                array('code' => '84111508', 'name' => 'Servicios de administración de contabilidad', 'business_client_id' => $client->id),
                array('code' => '80141601', 'name' => 'Servicios de Promocion de ventas', 'business_client_id' => $client->id)
            );
            BusinessClientConcept::insert($data);
        }

        $client = BusinessClient::where('code', 'RESCANTI_WORLD')
            ->whereNull('canceled_at')
            ->where('type', 'I')
            ->first();
        if ($client && BusinessClientConcept::
                where('business_client_id', $client->id)
                ->count() == 0) {
            $data = array(
                array('code' => '84111500', 'name' => 'Servicios contables', 'business_client_id' => $client->id),
                array('code' => '84111501', 'name' => 'Servicio de contabilidad de costos', 'business_client_id' => $client->id),
                array('code' => '84111502', 'name' => 'Servicio de contabilidad financiera', 'business_client_id' => $client->id),
                array('code' => '84111503', 'name' => 'Servicio de contabilidad fiscal', 'business_client_id' => $client->id),
                array('code' => '84111507', 'name' => 'Servicio de contabilidad de inventario', 'business_client_id' => $client->id),
                array('code' => '84111505', 'name' => 'Servicios de contabilidad de sueldos y salarios', 'business_client_id' => $client->id),
                array('code' => '84111800', 'name' => 'Asuntos y preparación de impuestos', 'business_client_id' => $client->id),
                array('code' => '84111800', 'name' => 'Cálculo de impuesto sobre nómina', 'business_client_id' => $client->id),
                array('code' => '84111800', 'name' => 'Cálculo de impuesto de seguridad social', 'business_client_id' => $client->id),
                array('code' => '84111800', 'name' => 'Servicios de cálculo de nómina', 'business_client_id' => $client->id),
                array('code' => '84111801', 'name' => 'Gestores Fiscales', 'business_client_id' => $client->id)
            );
            BusinessClientConcept::insert($data);
        }
        $client = BusinessClient::where('code', 'ARTICULOS_GRAU')
            ->whereNull('canceled_at')
            ->where('type', 'I')
            ->first();
        if ($client && BusinessClientConcept::
                where('business_client_id', $client->id)
                ->count() == 0) {
            $data = array(
                array('code' => '84111802', 'name' => 'Servicios de consultoría fiscal', 'business_client_id' => $client->id),
                array('code' => '80121602', 'name' => 'Servicios legales de quiebra', 'business_client_id' => $client->id),
                array('code' => '80121602', 'name' => 'Servicios legales para embargos', 'business_client_id' => $client->id),
                array('code' => '80121602', 'name' => 'Servicios legales de bancarrota', 'business_client_id' => $client->id),
                array('code' => '80121603', 'name' => 'Servicios de derecho mercantil', 'business_client_id' => $client->id),
                array('code' => '80121609', 'name' => 'Servicios de investigación legal', 'business_client_id' => $client->id),
                array('code' => '80121610', 'name' => 'Servicios legales de cobro de deudas o cartera', 'business_client_id' => $client->id),
                array('code' => '84111802', 'name' => 'Servicios de asesoría fiscal', 'business_client_id' => $client->id),
                array('code' => '93161800', 'name' => 'Servicios de temas tributarios', 'business_client_id' => $client->id),
                array('code' => '93161803', 'name' => 'Servicio de investigación tributaria', 'business_client_id' => $client->id),
                array('code' => '80121503', 'name' => 'Servicios para defensa o derecho penal', 'business_client_id' => $client->id),
                array('code' => '86101713', 'name' => 'Servicios de formación profesional en derecho', 'business_client_id' => $client->id),
                array('code' => '80121706', 'name' => 'Servicios legales sobre derecho laboral', 'business_client_id' => $client->id),
                array('code' => '80121707', 'name' => 'Servicios legales para disputas laborales', 'business_client_id' => $client->id),
                array('code' => '80121502', 'name' => 'Servicios para procesos de apelación', 'business_client_id' => $client->id)

            );
            BusinessClientConcept::insert($data);
        }
        $client = BusinessClient::where('code', 'REDMALL')
            ->whereNull('canceled_at')
            ->where('type', 'I')
            ->first();
        if ($client && BusinessClientConcept::
                where('business_client_id', $client->id)
                ->count() == 0) {
            $data = array(
                array('code' => '81101505', 'name' => 'Ingeniería estructural', 'business_client_id' => $client->id),
                array('code' => '81101508', 'name' => 'Ingeniería arquitectónica', 'business_client_id' => $client->id),
                array('code' => '81101513', 'name' => 'Gestión de construcción de edificios', 'business_client_id' => $client->id),
                array('code' => '81101703', 'name' => 'Servicios de pruebas de ingeniería', 'business_client_id' => $client->id),
                array('code' => '81101703', 'name' => 'Servicios de pruebas técnicas', 'business_client_id' => $client->id),
                array('code' => '81102702', 'name' => 'Servicio de ingeniería y diseño para sistemas de control de procesos', 'business_client_id' => $client->id),
                array('code' => '81141505', 'name' => 'Desarrollo de estándares de producción', 'business_client_id' => $client->id),
                array('code' => '81141601', 'name' => 'Logistica Maniobras Terrestres', 'business_client_id' => $client->id),
                array('code' => '81141500', 'name' => 'Control de calidad', 'business_client_id' => $client->id),
                array('code' => '81141500', 'name' => 'Servicios de Control de Calidad', 'business_client_id' => $client->id),
                array('code' => '81141600', 'name' => 'Manejo de cadena de suministros ', 'business_client_id' => $client->id),
                array('code' => '81141600', 'name' => 'Servicios de manejo de cadena de suministros', 'business_client_id' => $client->id),
                array('code' => '81141801', 'name' => 'Análisis de riesgo o seguridad', 'business_client_id' => $client->id),
                array('code' => '81141804', 'name' => 'Servicio de inspección de equipos', 'business_client_id' => $client->id),
                array('code' => '81141805', 'name' => 'Servicios de inspección de edificios', 'business_client_id' => $client->id),
                array('code' => '81141805', 'name' => 'Servicio de inspección de instalaciones electricas', 'business_client_id' => $client->id),
                array('code' => '81101515', 'name' => 'Ingeniería de infraestructura de instalaciones', 'business_client_id' => $client->id),
                array('code' => '81141807', 'name' => 'Servicios de inspección de plomería o alcantarillado', 'business_client_id' => $client->id),
                array('code' => '81141807', 'name' => 'Servicios de inspección de alcantarillado', 'business_client_id' => $client->id)
            );
            BusinessClientConcept::insert($data);
        }
        $client = BusinessClient::where('code', 'BB_DESPACHO')
            ->whereNull('canceled_at')
            ->where('type', 'I')
            ->first();
        if ($client && BusinessClientConcept::
                where('business_client_id', $client->id)
                ->count() == 0) {
            $data = array(
                array('code' => '84111801', 'name' => 'Gestores fiscales', 'business_client_id' => $client->id),
                array('code' => '84111802', 'name' => 'Servicios de asesoría fiscal ', 'business_client_id' => $client->id),
                array('code' => '84111802', 'name' => ' Servicios de consultoría fiscal', 'business_client_id' => $client->id),
                array('code' => '84111703', 'name' => 'Servicios de preparación o revisión de presupuestos', 'business_client_id' => $client->id),
                array('code' => '84111501', 'name' => 'Servicio de contabilidad de costos', 'business_client_id' => $client->id),
                array('code' => '84111502', 'name' => 'Servicio de contabilidad financiera', 'business_client_id' => $client->id),
                array('code' => '84111503', 'name' => 'Servicio de contabilidad fiscal', 'business_client_id' => $client->id),
                array('code' => '84111507', 'name' => 'Servicio de contabilidad de inventario', 'business_client_id' => $client->id),
                array('code' => '84111601', 'name' => 'Auditorias de cierre del ejercicio', 'business_client_id' => $client->id),
                array('code' => '84111602', 'name' => 'Revisiones trimestrales', 'business_client_id' => $client->id),
                array('code' => '84111603', 'name' => 'Auditorias internas', 'business_client_id' => $client->id),
                array('code' => '80101604', 'name' => 'Planificación o administración de proyectos', 'business_client_id' => $client->id),
                array('code' => '80101504', 'name' => 'Servicios de asesoramiento sobre planificación estratégica', 'business_client_id' => $client->id),
                array('code' => '93151501', 'name' => 'Servicios financieros o de gestión administrativa de empresas públicas', 'business_client_id' => $client->id),
                array('code' => '84111700', 'name' => 'Finanzas corporativas', 'business_client_id' => $client->id),
                array('code' => '80101603', 'name' => 'Evaluación económica de proyectos', 'business_client_id' => $client->id),
                array('code' => '84111500', 'name' => 'Servicios contables', 'business_client_id' => $client->id),
                array('code' => '80111505', 'name' => 'Auditorías de productividad de los recursos humanos', 'business_client_id' => $client->id),
                array('code' => '80111505', 'name' => 'Auditorías de productividad del capital humano', 'business_client_id' => $client->id),
                array('code' => '80161602', 'name' => 'Servicios de inventariado', 'business_client_id' => $client->id),
                array('code' => '84111603', 'name' => 'Auditorias internas de IVA', 'business_client_id' => $client->id),
                array('code' => '84111603', 'name' => 'Auditorias internas de ISR', 'business_client_id' => $client->id),
                array('code' => '84111603', 'name' => 'Auditorias internas de control interno.', 'business_client_id' => $client->id)
            );
            BusinessClientConcept::insert($data);
        }

        $client = BusinessClient::where('code', 'JARLOSA')
            ->whereNull('canceled_at')
            ->where('type', 'I')
            ->first();
        if ($client && BusinessClientConcept::
                where('business_client_id', $client->id)
                ->count() == 0) {
            $data = array(
                array('code' => '81101513', 'name' => 'Gestión de construcción de edificios', 'business_client_id' => $client->id),
                array('code' => '81101502', 'name' => 'Dibujo técnico', 'business_client_id' => $client->id),
                array('code' => '81141601', 'name' => 'Logística (Maniobras terrestres)', 'business_client_id' => $client->id),
                array('code' => '81141800', 'name' => 'Servicios de administración de instalaciones', 'business_client_id' => $client->id),
                array('code' => '81131500', 'name' => 'Servicios de metodología y analisis', 'business_client_id' => $client->id),
                array('code' => '81101512', 'name' => 'Servicios de Topografia', 'business_client_id' => $client->id),
                array('code' => '81131501', 'name' => 'Análisis de factores', 'business_client_id' => $client->id),
                array('code' => '81131504', 'name' => 'Encuestas por muestreo', 'business_client_id' => $client->id),
                array('code' => '81141801', 'name' => 'Análisis de riesgo o seguridad', 'business_client_id' => $client->id)
            );
            BusinessClientConcept::insert($data);
        }
    }
}
