<?php

use App\Model\Authorization;
use App\Model\CategoryAuthorization;
use Illuminate\Database\Seeder;

class AutorizationTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $data = [
            ['name' => 'Administración', 'index' => 1],
            ['name' => 'Facturación', 'index' => 2]
        ];
        CategoryAuthorization::insert($data);

        $admin = CategoryAuthorization::where('name', 'Administración')->first();
        $data = [
            ['code' => 'INTERNAL_CUSTOMERS', 'name' => 'Clientes internos',
                'index' => 100, 'category_authorization_id' => $admin->id],
            ['code' => 'EXTERNAL_CUSTOMERS', 'name' => 'Clientes externos',
                'index' => 200, 'category_authorization_id' => $admin->id],
            ['code' => 'PARTNERSHIPS', 'name' => 'Consorcios',
                'index' => 300, 'category_authorization_id' => $admin->id],
            ['code' => 'EMPLOYEES', 'name' => 'Empleados',
                'index' => 400, 'category_authorization_id' => $admin->id],
            ['code' => 'ISR_PERIODS', 'name' => 'Periodos ISR',
                'index' => 500, 'category_authorization_id' => $admin->id],
            ['code' => 'USERS', 'name' => 'Usuarios',
                'index' => 600, 'category_authorization_id' => $admin->id]
        ];
        Authorization::insert($data);

        $inv = CategoryAuthorization::where('name', 'Facturación')->first();
        $data = [
            ['code' => 'INVOICES', 'name' => 'Facturas',
                'index' => 100, 'category_authorization_id' => $inv->id],
            ['code' => 'ASSIMILATED_RECEIPTS', 'name' => 'Nómina para asimilados',
                'index' => 200, 'category_authorization_id' => $inv->id],
            ['code' => 'SALARIED_RECEIPTS', 'name' => 'Nómina para sueldos y salarios',
                'index' => 300, 'category_authorization_id' => $inv->id]
        ];
        Authorization::insert($data);
    }
}
