<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddRequestFileToScatterDetails extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('scatter_details', function (Blueprint $table) {
            $table->unsignedBigInteger('request_file_id')->nullable();
            $table->foreign('request_file_id')->references('id')->on('request_files');
        });

        Schema::dropIfExists('employee_scatter_files');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('scatter_details', function (Blueprint $table) {
            $table->dropForeign('scatter_details_request_file_id_foreign');
            $table->dropColumn('request_file_id');
        });
    }
}
