<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateScatterDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('scatter_details', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('employee_scatter_id');
            $table->double('amount');
            $table->string('status', 4)->nullable();
            $table->string('fac_status', 4)->nullable();
            $table->string('bank_status', 4)->nullable();
            $table->string('answer')->nullable();

            $table->timestamps();

            $table->foreign('employee_scatter_id')->references('id')->on('employee_scatters');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('scatter_details');
    }
}
