<?php

use App\Model\BankHistory;
use App\Model\EmployeeScatter;
use App\Model\PayrollWorkerReceipt;
use App\Model\ReceiptEmployeeScatter;
use App\Model\Request;
use App\Model\RequestDeposit;
use App\Model\RequestInvoice;
use App\Model\RequestInvoiceConcept;
use App\Model\WorkerReceiptReduction;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class AddCodeToRequestsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('requests', function (Blueprint $table) {
            $table->string('code', 32)->default('');
        });
        Request::getQuery()->update(['deleted_at' => DB::raw('now()')]);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('requests', function (Blueprint $table) {
            $table->dropColumn('code');
        });
    }
}
