<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWorkerReceiptReductionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('worker_receipt_reductions', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('payroll_worker_receipt_id');
            $table->string('code', 4);
            $table->string('concept', 256);
            $table->double('amount')->default(0);

            $table->timestamps();
            $table->softDeletes();

            $table->foreign('payroll_worker_receipt_id')->references('id')->on('payroll_worker_receipts');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('worker_receipt_reductions');
    }
}
