<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEmployeeScatterFilesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('employee_scatter_files', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('employee_scatter_id');
            $table->unsignedBigInteger('request_file_id');

            $table->timestamps();
            $table->softDeletes();

            $table->foreign('employee_scatter_id')->references('id')->on('employee_scatters');
            $table->foreign('request_file_id')->references('id')->on('request_files');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('employee_scatter_files');
    }
}
