<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateReceiptEmployeeScattersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('receipt_employee_scatters', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('employee_scatter_id');
            $table->unsignedBigInteger('payroll_receipt_id');

            $table->timestamps();
            $table->softDeletes();

            $table->foreign('employee_scatter_id')->references('id')->on('employee_scatters');
            $table->foreign('payroll_receipt_id')->references('id')->on('payroll_receipts');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('receipt_employee_scatters');
    }
}
