<?php

use App\Model\EmployeeScatter;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class AddAsToEmployeeScattersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('employee_scatters', function (Blueprint $table) {
            $table->double('sys')->default(0);
            $table->double('as')->default(0);
            $table->double('payed_as')->default(0);
        });

        EmployeeScatter::select('employee_scatters.*')
            ->join('requests', 'requests.id', '=', 'employee_scatters.request_id')
            ->join('employees', 'employees.id', '=', 'employee_scatters.employee_id')
            ->where('requests.status', 'R')
            ->whereNull('requests.deleted_at')
            ->where('employees.type', 'C')
            ->whereNull('employees.canceled_at')
            ->update(['employee_scatters.as' => DB::raw('round(employee_scatters.amount, 2)')]);
        
        EmployeeScatter::select('employee_scatters.*')
            ->join('requests', 'requests.id', '=', 'employee_scatters.request_id')
            ->join('payroll_worker_receipts', 'payroll_worker_receipts.employee_scatter_id', '=', 'employee_scatters.id')
            ->whereNotNull('payroll_worker_receipts.uuid')
            ->update(['employee_scatters.sys' => DB::raw('round(payroll_worker_receipts.total, 2)'),
                      'employee_scatters.as' => DB::raw('round(employee_scatters.amount - payroll_worker_receipts.total, 2)')]);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('employee_scatters', function (Blueprint $table) {
            $table->dropColumn('sys');
            $table->dropColumn('as');
        });
    }
}
