<?php

use App\Model\PayrollWorkerReceipt;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddIsrPeriodToPayrollWorkerReceiptTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('payroll_worker_receipts', function (Blueprint $table) {
            $table->unsignedBigInteger('isr_period_id')->nullable();
            $table->foreign('isr_period_id')->references('id')->on('isr_periods');
        });

        PayrollWorkerReceipt::whereNull('isr_period_id')->update(['isr_period_id' => 7]);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('payroll_worker_receipt', function (Blueprint $table) {
            //
        });
    }
}
