<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class AddScatterToPayrollWorkerReceiptsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('payroll_worker_receipts', function (Blueprint $table) {
            $table->unsignedBigInteger('employee_scatter_id')->nullable();
            $table->foreign('employee_scatter_id')->references('id')->on('employee_scatters');
        });

        DB::statement("update payroll_worker_receipts r
            join payroll_workers p on p.id = r.payroll_worker_id
            join employee_scatters e on e.request_id = p.request_id and r.employee_id = e.employee_id
            set r.employee_scatter_id = e.id
            where r.employee_scatter_id is null");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('payroll_worker_receipts', function (Blueprint $table) {
            $table->dropForeign('payroll_worker_receipts_employee_scatter_id_foreign');
            $table->dropColumn('employee_scatter_id');
        });
    }
}
