<?php

use App\Model\Authorization;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class RemoveClientToPayrollWorkers extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('payroll_workers', function (Blueprint $table) {
            $table->dropForeign('payroll_workers_business_client_id_foreign');
            $table->dropForeign('payroll_workers_business_branch_id_foreign');

            $table->dropColumn('business_client_id');
            $table->dropColumn('business_branch_id');
        });

        $data = [
            ['code' => 'SYS_DOWNLOADS', 'name' => 'Descargas de SYS', 'index' => 300, 'category_authorization_id' => 3],
            ['code' => 'SYS_STAMPEDS', 'name' => 'Timbres de SYS', 'index' => 400, 'category_authorization_id' => 3]
        ];
        Authorization::insert($data);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('payroll_workers', function (Blueprint $table) {
            //
        });
    }
}
