<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSubsidyDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('subsidy_details', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->double('lower_limit');
            $table->double('uper_limit')->nullable();
            $table->double('subsidy');
            
            $table->unsignedBigInteger('isr_period_id');
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('isr_period_id')->references('id')->on('isr_periods');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('subsidy_details');
    }
}
