<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePayrollWorkerReceiptsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payroll_worker_receipts', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('payroll_worker_id');
            $table->unsignedBigInteger('employee_id');

            $table->string('code', 64)->nullable();
            $table->string('uuid', 128)->nullable();
            $table->string('first_name', 128);
            $table->string('middle_name', 128)->nullable();
            $table->string('last_name', 128)->nullable();
            $table->string('rfc', 20);
            $table->string('curp', 32);
            $table->string('nss', 64)->nullable();

            $table->double('sdi');
            $table->double('integration_factor');
            $table->datetime('started_at');

            $table->string('infonavit_type', 4)->nullable();
            $table->double('infonavit_value')->nullable();
            
            $table->string('work_days');
            $table->double('subsidy');
            $table->double('subsidy_c');
            $table->double('isr');
            $table->double('infonavit');
            $table->double('imss');
                     
            $table->double('total');
            $table->string('payment_period', 4);
            $table->string('log')->nullable();
            $table->string('xml_file')->nullable();

            $table->datetime('invoice_date');
            //$table->datetime('pay_date');
            $table->datetime('pay_init');
            $table->datetime('pay_end');

            $table->dateTime('stamped_at')->nullable();
            $table->dateTime('canceled_at')->nullable();
            $table->string('stamp_signer', 8)->nullable();
            $table->string('cancel_signer', 8)->nullable();
            
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('payroll_worker_id')->references('id')->on('payroll_workers');
            $table->foreign('employee_id')->references('id')->on('employees');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payroll_worker_receipts');
    }
}
