<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePayrollWorkersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payroll_workers', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('code');
            $table->unsignedBigInteger('request_id')->nullable(false);
            $table->unsignedBigInteger('isr_period_id')->nullable(false);
            $table->unsignedBigInteger('business_client_id')->nullable(false);
            $table->unsignedBigInteger('business_branch_id')->nullable(false);

            //$table->decimal('uma', 8, 5);
            $table->double('salary_min');
            //$table->decimal('rt', 8, 5);
            $table->double('umi');
            $table->double('insurance');
            $table->dateTime('payed_at');
            $table->datetime('pay_init');
            $table->datetime('pay_end');
            $table->dateTime('invoiced_at');

            $table->timestamps();
            $table->softDeletes();

            $table->foreign('request_id')->references('id')->on('requests');
            $table->foreign('isr_period_id')->references('id')->on('isr_periods');
            $table->foreign('business_client_id')->references('id')->on('business_clients');
            $table->foreign('business_branch_id')->references('id')->on('business_branches');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payroll_workers');
    }
}
