<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class RefactorEmployeesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('employees', function (Blueprint $table) {
            $table->decimal('integration_factor', 15, 8)->change();
            $table->decimal('sdi', 15, 8)->change();
            $table->decimal('infonavit_value', 15, 8)->change();
        });

        Schema::table('employee_scatters', function (Blueprint $table) {
            $table->integer('work_days')->default(0);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('employees', function (Blueprint $table) {
            $table->decimal('integration_factor')->change();
            $table->decimal('sdi')->change();
            $table->decimal('infonavit_value')->change();
        });
        
        Schema::table('employee_scatters', function (Blueprint $table) {
            $table->dropColumn('work_days');
        });
    }
}
