<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddDepositToRequestInvoicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('request_invoices', function (Blueprint $table) {
            $table->unsignedBigInteger('request_deposit_id')->nullable();
            $table->foreign('request_deposit_id')->references('id')->on('request_deposits');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('request_invoices', function (Blueprint $table) {
            $table->dropForeign('request_invoices_request_deposit_id_foreign');
            $table->dropColumn('request_deposit_id');
        });
    }
}
