<?php

use App\Model\Invoice;
use App\Model\Payroll;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddUserToInvoicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('invoices', function (Blueprint $table) {
            $table->unsignedBigInteger('user_id')->nullable();            
            $table->foreign('user_id')->references('id')->on('users');
        });
        Schema::table('payrolls', function (Blueprint $table) {
            $table->unsignedBigInteger('user_id')->nullable();            
            $table->foreign('user_id')->references('id')->on('users');
        });

        Invoice::withTrashed()->update(['user_id' => 4]);
        Payroll::whereNull('user_id')->update(['user_id' => 4]);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('invoices', function (Blueprint $table) {
            $table->dropForeign('invoices_user_id_foreign');
            $table->dropColumn('user_id');
        });
        Schema::table('payrolls', function (Blueprint $table) {
            $table->dropForeign('payrolls_user_id_foreign');
            $table->dropColumn('user_id');
        });
    }
}
