<?php

use App\Model\PartnershipConcepts;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddStatusToPartnershipConceptsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('partnership_concepts', function (Blueprint $table) {
            $table->string('status', 8)->nullable();
        });
        PartnershipConcepts::whereNull('status')->update(['status' => '1']);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('partnership_concepts', function (Blueprint $table) {
            $table->dropColumn('status');
        });
    }
}
