<?php

use App\Model\Request;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddEmployeeToEmployeeScattersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('employee_scatters', function (Blueprint $table) {
            $table->unsignedBigInteger('employee_id')->nullable();
            $table->foreign('employee_id')->references('id')->on('employees');

            $table->dropColumn('type');
            $table->dropColumn('rfc');
            $table->dropColumn('name');
            $table->dropColumn('pay_method');
        });

        Request::where('id', '>', 0)->delete();
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('employee_scatters', function (Blueprint $table) {
            $table->dropForeign('employee_scatters_employee_id_foreign');
            $table->dropColumn('employee_id');

            $table->string('type', 8);
            $table->string('rfc', 32);
            $table->string('name', 256);
            $table->string('pay_method', 128);
        });
    }
}
