<?php

use App\Model\Employee;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddInformationToEmployeesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('employees', function (Blueprint $table) {
            $table->decimal('sdi')->nullable();
            $table->decimal('salary')->nullable();
            $table->decimal('integration_factor')->nullable();
            $table->dateTime('started_at')->nullable();
            $table->dateTime('finished_at')->nullable();
            $table->string('infonavit_type')->nullable();
            $table->decimal('infonavit_value')->nullable();
            $table->string('address')->nullable();
            $table->unsignedBigInteger('bank_id')->nullable();
            $table->string('account', 32)->nullable();
            $table->string('civil_status', 4)->nullable();
            $table->string('ine_file')->nullable();
            $table->string('rfc_file')->nullable();
            $table->string('curp_file')->nullable();
            $table->string('federative_key', 8)->nullable();
            $table->string('payroll_type', 8)->nullable();
            $table->string('contract_type', 8)->nullable();
            $table->string('regime_type', 8)->nullable();
            $table->string('workstation_risk', 8)->nullable();
            $table->string('employer_register')->nullable();

            $table->string('nss', 32)->nullable();
            $table->string('workstation', 256)->nullable();
            $table->string('payment_period', 8)->nullable();
            $table->string('infonavit_file')->nullable();
            $table->string('nss_file')->nullable();

            $table->foreign('bank_id')->references('id')->on('banks');
        });

        Employee::whereNull('civil_status')->update(['civil_status' => 'S']);
        Employee::whereNotNull('type')->update(['type' => 'C']);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('employees', function (Blueprint $table) {
            $table->dropColumn('sdi');
            $table->dropColumn('salary');   
            $table->dropColumn('integration_factor');
            $table->dropColumn('started_at');
            $table->dropColumn('finished_at');
            $table->dropColumn('infonavit_type');
            $table->dropColumn('infonavit_value');
            $table->dropColumn('address');
            $table->dropColumn('account');
            $table->dropColumn('civil_status');
            $table->dropColumn('ine_file');
            $table->dropColumn('rfc_file');
            $table->dropColumn('curp_file');
            $table->dropColumn('federative_key');
            $table->dropColumn('payroll_type');
            $table->dropColumn('contract_type');
            $table->dropColumn('regime_type');
            $table->dropColumn('workstation_risk');
            $table->dropColumn('employer_register');

            $table->dropColumn('nss');
            $table->dropColumn('workstation');
            $table->dropColumn('payment_period');
            $table->dropColumn('infonavit_file');
            $table->dropColumn('nss_file');

            $table->dropForeign('employees_bank_id_foreign');
            $table->dropColumn('bank_id');
        });
    }
}
