<?php

use App\Model\BusinessClient;
use Carbon\Carbon;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddStatusToBusinessClientsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('business_clients', function (Blueprint $table) {
            $table->string('status', 4)->nullable();
            $table->dateTime('released_at')->nullable();
            $table->unsignedBigInteger('released_by')->nullable();

            $table->foreign('released_by')->references('id')->on('users');
        });

        BusinessClient::whereNull('status')->update(['status' => 'R']);
        BusinessClient::where('type', 'E')->update(['released_at' => Carbon::now()]);
        BusinessClient::whereNull('released_by')->update(['released_by' => 1]);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('business_clients', function (Blueprint $table) {
            $table->dropColumn('status');
            $table->dropColumn('released_at');

            $table->dropForeign('business_clients_released_by_foreign');
            $table->dropColumn('released_by');
        });
    }
}
