<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEmployeeScattersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('employee_scatters', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('request_id');
            $table->string('type', 8);
            $table->string('rfc', 32);
            $table->string('name', 256);
            $table->string('pay_method', 128);
            $table->unsignedBigInteger('bank_id');
            $table->string('account', 32);
            $table->double('amount');

            $table->timestamps();

            $table->foreign('request_id')->references('id')->on('requests');
            $table->foreign('bank_id')->references('id')->on('banks');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('employee_scatters');
    }
}
