<?php

use App\Model\Bank;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBanksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('banks', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name');

            $table->softDeletes();
            $table->timestamps();
        });

        $data = array(
            array('name' => 'Banamex'),
            array('name' => 'Bancomer'),
            array('name' => 'Scotia Bank'),
            array('name' => 'Santander'),
            array('name' => 'Ban bajio'),
            array('name' => 'Banorte'),
            array('name' => 'Inbursa'),
            array('name' => 'Banco Azteca'),
            array('name' => 'Banco de México'),
            array('name' => 'HSBC'),
            array('name' => 'BANCOPPEL, S.A')
        );
        Bank::insert($data);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('banks');
    }
}
