<?php

use App\Model\BusinessClient;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddFilesToBusinessClientsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('business_clients', function (Blueprint $table) {
            $table->string('client_type', 8)->nullable();
            $table->string('rfc_file')->nullable();
            $table->string('address_file')->nullable();
            $table->string('constitutive_act_file')->nullable();
            $table->string('ife_file')->nullable();
            $table->string('identification_card_file')->nullable();
            $table->string('main_identification_card_file')->nullable();
        });

        BusinessClient::where('type', 'E')->update(['client_type' => 'M']);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('business_clients', function (Blueprint $table) {
            //
        });
    }
}
