<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRequestInvoiceConceptsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('request_invoice_concepts', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('request_invoice_id');
            $table->unsignedBigInteger('partnership_concept_id');
            $table->string('description');
            $table->double('amount');

            $table->timestamps();
            $table->softDeletes();

            $table->foreign('request_invoice_id')->references('id')
                ->on('request_invoices');
            $table->foreign('partnership_concept_id')->references('id')
                ->on('partnership_concepts');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('request_invoice_concepts');
    }
}
