<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRequestInvoicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('request_invoices', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('request_id');
            $table->unsignedBigInteger('emissor_id');
            $table->unsignedBigInteger('receiver_id');
            $table->double('amount');

            $table->timestamps();
            $table->softDeletes();
            
            $table->foreign('request_id')->references('id')->on('requests');
            $table->foreign('emissor_id')->references('id')
                ->on('business_clients');
            $table->foreign('receiver_id')->references('id')
                ->on('business_clients');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('request_invoices');
    }
}
