<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddPartnershipToPartnershipConceptsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('partnership_concepts', function (Blueprint $table) {
            $table->unsignedBigInteger('partnership_id');
            $table->foreign('partnership_id')->references('id')
                ->on('partnerships');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('partnership_concepts', function (Blueprint $table) {
            $table->dropForeign('partnership_concepts_partnership_id_foreign');
            $table->dropColumn('partnership_id');            
        });
    }
}
