<?php

use App\Model\Invoice;
use App\Model\PayrollReceipt;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddSignerToInvoicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('invoices', function (Blueprint $table) {
            $table->string('stamp_signer', 8)->nullable();
            $table->string('cancel_signer', 8)->nullable();
        });

        Schema::table('payroll_receipts', function (Blueprint $table) {
            $table->string('stamp_signer', 8)->nullable();
            $table->string('cancel_signer', 8)->nullable();
        });

        Invoice::whereNotNull('uuid')->update(['stamp_signer' => 'FM']);
        Invoice::whereNotNull('canceled_at')->update(['cancel_signer' => 'FM']);

        PayrollReceipt::whereNotNull('uuid')->update(['stamp_signer' => 'FM']);
        PayrollReceipt::whereNotNull('canceled_at')
            ->update(['cancel_signer' => 'FM']);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('invoices', function (Blueprint $table) {
            $table->dropColumn('stamp_signer');
            $table->dropColumn('cancel_signer');
        });
        Schema::table('payroll_receipts', function (Blueprint $table) {
            $table->dropColumn('stamp_signer');
            $table->dropColumn('cancel_signer');
        });
    }
}
