<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePartnershipConceptsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('partnership_concepts', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('code', 32);
            $table->string('description', 512);
            $table->unsignedBigInteger('business_client_id');

            $table->softDeletes();
            $table->timestamps();

            $table->foreign('business_client_id')->references('id')
                ->on('business_clients');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('partnership_concepts');
    }
}
