<?php

use App\Model\BusinessClientConcept;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddTypeColumnToBusinessClientConcepts extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('business_client_concepts', function (Blueprint $table) {
            $table->string('type', 8)->nullable();
        });
        BusinessClientConcept::where('id', '>=', 0)
                ->update(['type' => 'C']);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('business_client_concepts', function (Blueprint $table) {
            $table->dropColumn('type');
        });
    }
}
