<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAuthorizationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('authorizations', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('code', 256);
            $table->string('name');
            $table->integer('index');
            $table->unsignedBigInteger('category_authorization_id');
            $table->unsignedBigInteger('authorization_id')->nullable();            
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('category_authorization_id')->references('id')
                ->on('category_authorizations');
            $table->foreign('authorization_id')->references('id')
                ->on('authorizations');            
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('authorizations');
    }
}
