<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBusinessClientEmployeesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('business_client_employees', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->unsignedBigInteger('business_client_id');
            $table->unsignedBigInteger('employee_id');

            $table->timestamps();
            $table->softDeletes();

            $table->foreign('business_client_id')->references('id')
                ->on('business_clients');
            $table->foreign('employee_id')->references('id')->on('employees');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('business_client_employees');
    }
}
