<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddPartnershipToEmployeesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('employees', function (Blueprint $table) {
            $table->unsignedBigInteger('partnership_id')->nullable();

            $table->foreign('partnership_id')->references('id')
                ->on('partnerships');
            
            $table->dropForeign('employees_business_client_id_foreign');
            $table->dropColumn('business_client_id');

            $table->dropForeign('employees_business_department_id_foreign');
            $table->dropColumn('business_department_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('employees', function (Blueprint $table) {
            $table->dropForeign('employees_partnership_id_foreign');
            $table->removeColumn('partnership_id');
        });
    }
}
