<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddPartnershipToBusinessClientsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('business_clients', function (Blueprint $table) {
            $table->unsignedBigInteger('partnership_id')->nullable();

            $table->foreign('partnership_id')->references('id')
                ->on('partnerships');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('business_clients', function (Blueprint $table) {
            $table->removeColumn('partnership_id');
        });
    }
}
